/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.MayorEntity;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.quests.ActionType;
import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.common.quests.quest.DisplayInfo;
import dev.toma.gunsrpg.common.quests.quest.IAdditionalClientInfo;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.reward.QuestReward;
import dev.toma.gunsrpg.common.skills.BartenderSkill;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_QuestActionPacket;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.math.IDimensions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import lib.toma.animations.engine.screen.animator.widget.WidgetContainer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class QuestScreen
extends Screen {
    private static final IFormattableTextComponent TEXT_AVAILABLE_QUESTS = new TranslationTextComponent("screen.quests.available_quests");
    private static final IFormattableTextComponent TEXT_ACTIVE_QUESTS = new TranslationTextComponent("screen.quests.active_quests");
    private static final IFormattableTextComponent TEXT_NO_QUESTS = new TranslationTextComponent("screen.quests.no_quests");
    private static final IFormattableTextComponent TEXT_QUEST_NAME = new TranslationTextComponent("screen.quests.quest_name");
    private static final IFormattableTextComponent TEXT_QUEST_DETAIL = new TranslationTextComponent("screen.quests.quest_detail");
    private static final IFormattableTextComponent TEXT_QUEST_CONDITIONS = new TranslationTextComponent("screen.quests.conditions");
    private static final IFormattableTextComponent TEXT_QUEST_REWARDS = new TranslationTextComponent("screen.quests.rewards");
    private static final ITextComponent TEXT_QUEST_OTHER_ACTIVE = new TranslationTextComponent("screen.quests.has_other_active").func_240699_a_(TextFormatting.RED);
    private static final ITextComponent TEXT_QUEST_NO_REWARDS = new TranslationTextComponent("screen.quests.no_rewards").func_240699_a_(TextFormatting.RED);
    private static final IFormattableTextComponent DIALOG_REWARD_HEADER = new TranslationTextComponent("screen.dialog.quest.reward.header");
    private static final IFormattableTextComponent DIALOG_CANCEL_HEADER = new TranslationTextComponent("screen.dialog.quest.cancel.header");
    private static final ITextComponent DIALOG_REWARD_INFO = new TranslationTextComponent("screen.dialog.quest.reward.info");
    private static final ITextComponent DIALOG_CANCEL_INFO = new TranslationTextComponent("screen.dialog.quest.cancel.info");
    private static final ITextComponent DIALOG_CANCEL_DANGER = new TranslationTextComponent("screen.dialog.quest.cancel.danger").func_240699_a_(TextFormatting.RED);
    private static final String TEXT_MAYOR_STATUS_RAW = "screen.quests.mayor_status";
    private static final Function<IFormattableTextComponent, IFormattableTextComponent> TEXT_MAYOR_STATUS = text -> new TranslationTextComponent(TEXT_MAYOR_STATUS_RAW, new Object[]{text});
    private static final String TEXT_RESTOCK_TIMER_RAW = "screen.quests.restock_timer";
    private static final Function<IFormattableTextComponent, IFormattableTextComponent> TEXT_RESTOCK_TIMER = time -> new TranslationTextComponent(TEXT_RESTOCK_TIMER_RAW, new Object[]{time});
    private static final String TEXT_QUEST_TIER_RAW = "screen.quests.quest_tier";
    private static final Function<IFormattableTextComponent, IFormattableTextComponent> TEXT_QUEST_TIER = tier -> new TranslationTextComponent(TEXT_QUEST_TIER_RAW, new Object[]{tier});
    private static final Interval.IFormatFactory RESTOCK_TIMER_FORMAT = format -> format.src(Interval.Unit.TICK).out(Interval.Unit.HOUR, Interval.Unit.MINUTE, Interval.Unit.SECOND).compact();
    private static final Function<Integer, String> FORMATTER = ticks -> Interval.format(ticks, RESTOCK_TIMER_FORMAT);
    private final ReputationStatus status;
    private final Quest<?>[] quests;
    private final MayorEntity entity;
    private IQuests questProvider;
    private boolean hasActiveQuest;
    private QuestInfoPanelWidget infoPanelWidget;
    private Quest<?> selectedQuest;

    public QuestScreen(ReputationStatus status, Quest<?>[] quests, MayorEntity entity, long timer) {
        super((ITextComponent)new TranslationTextComponent("screen.gunsrpg.quests"));
        this.status = status;
        this.quests = quests;
        this.entity = entity;
        this.entity.setClientTimer(timer);
    }

    protected void func_231160_c_() {
        IPlayerData data = PlayerData.getUnsafe((PlayerEntity)this.field_230706_i_.field_71439_g);
        this.questProvider = data.getQuests();
        ISkillProvider skillProvider = data.getSkillProvider();
        this.hasActiveQuest = this.questProvider.getActiveQuest().isPresent();
        for (int i = 0; i < this.quests.length; ++i) {
            Quest<?> quest2 = this.quests[i];
            this.func_230480_a_(new QuestWidget(10, 25 + i * 30, this.field_230708_k_ / 3, 25, quest2, this::questWidgetClicked));
        }
        this.questProvider.getActiveQuest().ifPresent(quest -> {
            QuestWidget cfr_ignored_0 = (QuestWidget)this.func_230480_a_(new QuestWidget(10, this.field_230709_l_ - 30, this.field_230708_k_ / 3, 25, (Quest<?>)quest, this::questWidgetClicked));
        });
        int panelLeft = 30 + this.field_230708_k_ / 3;
        int panelWidth = this.field_230708_k_ - panelLeft - 10;
        this.infoPanelWidget = (QuestInfoPanelWidget)this.func_230480_a_(new QuestInfoPanelWidget(panelLeft, 0, panelWidth, this.field_230709_l_, skillProvider, this.field_230712_o_));
        this.infoPanelWidget.setSelectedQuest(this.selectedQuest);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
        RenderUtils.drawSolid(pose, 5, 0, this.field_230708_k_ / 3 + 15, this.field_230709_l_, 0x66000000);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)TEXT_AVAILABLE_QUESTS, 10.0f, 10.0f, 0xFFFFFF);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)TEXT_ACTIVE_QUESTS, 10.0f, (float)(this.field_230709_l_ - 45), 0xFFFFFF);
        IFormattableTextComponent statusComponent = TEXT_MAYOR_STATUS.apply(this.status.getStatusDescriptor());
        int remainingTime = (int)this.entity.getRemainingRestockTime();
        TranslationTextComponent timeComponent = new TranslationTextComponent(this.getTimerColor(remainingTime) + FORMATTER.apply(remainingTime));
        IFormattableTextComponent timerComponent = TEXT_RESTOCK_TIMER.apply((IFormattableTextComponent)timeComponent);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)statusComponent, (float)(this.infoPanelWidget.field_230690_l_ + 5), 10.0f, 0xFFFFFF);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)timerComponent, (float)(this.infoPanelWidget.field_230690_l_ + this.infoPanelWidget.func_230998_h_() - 5 - this.field_230712_o_.func_238414_a_((ITextProperties)timerComponent)), 10.0f, 0xFFFFFF);
        if (!this.hasActiveQuest) {
            this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)TEXT_NO_QUESTS, 10.0f + ((float)this.field_230708_k_ / 3.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)TEXT_NO_QUESTS)) / 2.0f, (float)(this.field_230709_l_ - 22), 0xFF5555);
        }
        if (this.quests.length == 0) {
            this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)TEXT_NO_QUESTS, 10.0f + ((float)this.field_230708_k_ / 3.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)TEXT_NO_QUESTS)) / 2.0f, 20.0f + (float)this.field_230709_l_ * 0.2f, 0xFF5555);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void questWidgetClicked(QuestWidget widget) {
        Quest quest = widget.quest;
        this.infoPanelWidget.setSelectedQuest(quest);
        this.selectedQuest = quest;
    }

    private void renderItemTooltip(MatrixStack matrix, ItemStack stack, int mouseX, int mouseY) {
        this.func_230457_a_(matrix, stack, mouseX, mouseY);
    }

    private void refreshAllWidgets() {
        MainWindow window = this.field_230706_i_.func_228018_at_();
        this.func_231158_b_(this.field_230706_i_, window.func_198107_o(), window.func_198087_p());
    }

    private TextFormatting getTimerColor(int timer) {
        Interval interval = Interval.ticks(timer);
        if (Interval.minutes(30).compareTo(interval) > 0) {
            return TextFormatting.GREEN;
        }
        if (Interval.minutes(10).compareTo(interval) > 0) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.RED;
    }

    static {
        TEXT_AVAILABLE_QUESTS.func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.AQUA});
        TEXT_ACTIVE_QUESTS.func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.GREEN});
    }

    private static class ItemStackDisplay {
        private final Item item;
        private final int count;
        private final ItemStack rendererHolder;

        public ItemStackDisplay(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.count = stack.func_190916_E();
            this.rendererHolder = stack;
        }

        private ItemStackDisplay(int count, ItemStack stack) {
            this.item = stack.func_77973_b();
            this.count = count;
            this.rendererHolder = stack;
        }

        public ItemStackDisplay increment(int count) {
            return new ItemStackDisplay(this.count + count, this.rendererHolder);
        }

        public static ItemStackDisplay[] fromReward(QuestReward reward) {
            return ItemStackDisplay.fromSelectedReward(reward.getChoices());
        }

        public static ItemStackDisplay[] fromSelectedReward(QuestReward.Choice[] choices) {
            List<ItemStack> items = Arrays.stream(choices).flatMap(choice -> Arrays.stream(choice.getContents())).collect(Collectors.toList());
            return ItemStackDisplay.collapse(items);
        }

        public static ItemStackDisplay[] collapse(Collection<ItemStack> itemStacks) {
            Map<Item, List<ItemStack>> map = itemStacks.stream().collect(Collectors.groupingBy(ItemStack::func_77973_b));
            int index = 0;
            ItemStackDisplay[] displays = new ItemStackDisplay[map.size()];
            for (Map.Entry<Item, List<ItemStack>> entry : map.entrySet()) {
                List<ItemStack> items = entry.getValue();
                ItemStackDisplay display = new ItemStackDisplay(items.get(0));
                for (int i = 1; i < items.size(); ++i) {
                    display = display.increment(items.get(i).func_190916_E());
                }
                displays[index++] = display;
            }
            return displays;
        }
    }

    private static final class ConfirmDialog
    extends Screen {
        private final Screen parent;
        private final ITextComponent header;
        private final ITextComponent[] content;
        private final Consumer<Screen> onConfirm;
        private IDimensions dimensions;
        private ITextComponent confirmText = new TranslationTextComponent("screen.dialog.confirm");
        private ITextComponent denyText = new TranslationTextComponent("screen.dialog.deny");
        private int left;
        private int top;

        private ConfirmDialog(Screen parent, IFormattableTextComponent header, ITextComponent[] content, Consumer<Screen> onConfirm) {
            super(parent.func_231171_q_());
            this.parent = parent;
            this.header = header.func_240699_a_(TextFormatting.UNDERLINE);
            this.content = content;
            this.onConfirm = onConfirm;
        }

        protected void func_231160_c_() {
            this.parent.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            int panelWidth = Math.max(this.field_230712_o_.func_238414_a_((ITextProperties)this.header) + 10, 150);
            List contentList = Arrays.stream(this.content).map(text -> this.field_230712_o_.func_238425_b_((ITextProperties)text, panelWidth)).flatMap(Collection::stream).collect(Collectors.toList());
            int panelHeight = 50 + contentList.size() * 10;
            this.dimensions = IDimensions.of(panelWidth, panelHeight);
            this.left = (this.field_230708_k_ - this.dimensions.getWidth()) / 2;
            this.top = (this.field_230709_l_ - this.dimensions.getHeight()) / 2;
            this.func_230480_a_(new LabelWidget(this.left + 5, this.top + 5, panelWidth - 10, 10, this.header, this.field_230712_o_));
            int i = 0;
            for (IReorderingProcessor processor : contentList) {
                this.func_230480_a_(new ReorderedTextWidget(this.left + 5, this.top + 20 + i++ * 10, panelWidth - 10, 10, processor, this.field_230712_o_));
            }
            int btnWidth = (panelWidth - 15) / 2;
            this.func_230480_a_((Widget)new Button(this.left + 5, this.top + panelHeight - 25, btnWidth, 20, this.denyText, this::refused));
            this.func_230480_a_((Widget)new Button(this.left + panelWidth - 5 - btnWidth, this.top + panelHeight - 25, btnWidth, 20, this.confirmText, this::accepted));
        }

        private void refused(Button button) {
            this.field_230706_i_.func_147108_a(this.parent);
        }

        private void accepted(Button button) {
            this.onConfirm.accept(this.parent);
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.parent.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 900.0);
            Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
            RenderUtils.drawSolid(pose, 0, 0, this.parent.field_230708_k_, this.parent.field_230709_l_, -587202560);
            RenderUtils.drawGradient(pose, this.left, this.top, this.left + this.dimensions.getWidth(), this.top + this.dimensions.getHeight(), -3355648, -5592576);
            RenderUtils.drawSolid(pose, this.left + 1, this.top + 1, this.left + this.dimensions.getWidth() - 1, this.top + this.dimensions.getHeight() - 1, -16777216);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            matrix.func_227865_b_();
        }

        public boolean func_231177_au__() {
            return false;
        }

        public void setConfirmText(ITextComponent confirmText) {
            this.confirmText = confirmText;
        }

        public void setDenyText(ITextComponent denyText) {
            this.denyText = denyText;
        }
    }

    private static final class ChoiceWidget
    extends Widget {
        private final int choiceIndex;
        private final FontRenderer font;
        private final Consumer<ChoiceWidget> clickResponder;
        private boolean selected;

        public ChoiceWidget(int x, int y, int width, int height, int choiceIndex, FontRenderer font, Consumer<ChoiceWidget> clickResponder) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.choiceIndex = choiceIndex;
            this.font = font;
            this.clickResponder = clickResponder;
        }

        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            boolean selected = this.selected || this.field_230692_n_;
            float thickness = selected ? 2.0f : 1.0f;
            int color = selected ? -256 : -1;
            RenderUtils.drawBorder(stack.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, thickness, color);
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            this.clickResponder.accept(this);
        }

        public void setSelected(boolean state) {
            this.selected = state;
        }
    }

    private final class RewardsWidget
    extends WidgetContainer {
        private final int selectionSize;
        private final Consumer<Integer[]> selectionIndexConsumer;
        private final Set<ChoiceWidget> choices;

        public RewardsWidget(int x, int y, int width, int height, Quest<?> quest, int selectionSize, Consumer<Integer[]> selectionIndexConsumer) {
            super(x, y, width, height);
            this.choices = new HashSet<ChoiceWidget>();
            this.selectionSize = selectionSize;
            this.selectionIndexConsumer = selectionIndexConsumer;
            int oneThird = width / 3;
            QuestReward reward = quest.getReward();
            QuestReward.Choice[] choices = reward.getChoices();
            int index = 0;
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer font = mc.field_71466_p;
            ItemRenderer itemRenderer = mc.func_175599_af();
            for (int i = 0; i < choices.length; ++i) {
                this.addWidget(new ChoiceWidget(5, index * 30, oneThird, 25, index, font, this::trySelectChoice));
                ++index;
            }
            index = 0;
            for (QuestReward.Choice choice : choices) {
                List<ItemStack> items = Arrays.asList(choice.getContents());
                ItemStackDisplay[] displays = ItemStackDisplay.collapse(items);
                for (int i = 0; i < displays.length; ++i) {
                    this.addWidget(new ItemStackWidget(10 + i * 25, 4 + index * 30, 16, 16, displays[i], font, itemRenderer, (x$0, x$1, x$2, x$3) -> QuestScreen.this.renderItemTooltip(x$0, x$1, x$2, x$3)));
                }
                ++index;
            }
        }

        @Override
        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            String text = this.choices.size() + "/" + this.selectionSize;
            float f = this.field_230690_l_ + this.field_230688_j_ - font.func_78256_a(text);
            font.getClass();
            font.func_238405_a_(stack, text, f, (float)(this.field_230691_m_ + this.field_230689_k_ - 9), 0xFFFFFF);
        }

        private void trySelectChoice(ChoiceWidget widget) {
            if (this.choices.contains((Object)widget)) {
                this.choices.remove((Object)widget);
                widget.setSelected(false);
            } else if (this.choices.size() < this.selectionSize) {
                this.choices.add(widget);
                widget.setSelected(true);
            }
            Integer[] selectedIndexes = (Integer[])this.choices.stream().map(choiceWidget -> ((ChoiceWidget)choiceWidget).choiceIndex).toArray(Integer[]::new);
            this.selectionIndexConsumer.accept(selectedIndexes);
        }
    }

    private static final class ActionButton
    extends Widget {
        private final ActionType actionType;
        private final Consumer<ActionType> consumer;

        private ActionButton(int x, int y, int width, int height, ActionType type, Consumer<ActionType> consumer) {
            super(x, y, width, height, type.getText());
            this.actionType = type;
            this.consumer = consumer;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            RenderUtils.drawBorder(matrix.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, 1.25f, !this.field_230693_o_ ? -5636096 : (this.field_230692_n_ ? -16711902 : -16733696));
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            ITextComponent text = this.func_230458_i_();
            float f = (float)this.field_230690_l_ + (float)(this.field_230688_j_ - font.func_238414_a_((ITextProperties)text)) / 2.0f;
            float f2 = this.field_230691_m_;
            font.getClass();
            font.func_243246_a(matrix, text, f, f2 + (float)(this.field_230689_k_ - 9) / 2.0f, this.field_230693_o_ ? 0xFFFFFF : 0xAA3333);
        }

        public void func_230982_a_(double p_230982_1_, double p_230982_3_) {
            this.consumer.accept(this.actionType);
        }
    }

    private static final class ReorderedTextWidget
    extends Widget {
        private final IReorderingProcessor processor;
        private final FontRenderer font;

        private ReorderedTextWidget(int x, int y, int width, int height, IReorderingProcessor processor, FontRenderer font) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.processor = processor;
            this.font = font;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.font.func_238407_a_(matrix, this.processor, (float)this.field_230690_l_, (float)this.field_230691_m_, 0xFFFFFF);
        }
    }

    private final class QuestInfoPanelWidget
    extends ContainerWidget {
        private final FontRenderer font;
        private final ISkillProvider provider;
        private Quest<?> selectedQuest;
        private Integer[] selectedIndexes;
        private ActionButton actionButton;

        public QuestInfoPanelWidget(int x, int y, int width, int height, ISkillProvider provider, FontRenderer font) {
            super(x, y, width, height);
            this.selectedIndexes = new Integer[0];
            this.provider = provider;
            this.font = font;
        }

        @Override
        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            RenderUtils.drawSolid(stack.func_227866_c_().func_227870_a_(), this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 0x66000000);
            super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
        }

        public void setSelectedQuest(Quest<?> quest) {
            boolean isRewardCollectionAllowed;
            this.clear();
            Quest<?> quest2 = this.selectedQuest = quest == this.selectedQuest || this.shouldHideQuest(quest) ? null : quest;
            if (this.selectedQuest == null) {
                return;
            }
            QuestScheme<?> scheme = this.selectedQuest.getScheme();
            DisplayInfo displayInfo = scheme.getDisplayInfo();
            IQuestCondition[] conditions = this.selectedQuest.getConditions();
            QuestStatus status = this.selectedQuest.getStatus();
            boolean isSpecial = this.selectedQuest.getScheme().isSpecialTaskQuest();
            int y = 0;
            int offset = 15;
            this.addTitle(y, TEXT_QUEST_NAME, TextFormatting.YELLOW, TextFormatting.BOLD);
            this.addDetail(y += offset, displayInfo.getName(), TextFormatting.ITALIC);
            ActionType actionType = this.getQuestActionType(status);
            UUID traderId = QuestScreen.this.entity.func_110124_au();
            UUID questId = this.selectedQuest.getOriginalAssignerId();
            boolean bl = isRewardCollectionAllowed = Objects.equals(traderId, questId) || questId.equals(Util.field_240973_b_) || actionType == ActionType.CANCEL;
            if (status.shouldShowRewards() && isRewardCollectionAllowed && !isSpecial) {
                this.addTitle(y += offset, TEXT_QUEST_REWARDS, TextFormatting.YELLOW, TextFormatting.BOLD);
                BartenderSkill bartenderSkill = SkillUtil.getTopHierarchySkill(Skills.BARTENDER_I, this.provider);
                int selectionSize = bartenderSkill != null ? bartenderSkill.getRewardCount() : 1;
                this.addWidget(new RewardsWidget(this.field_230690_l_ + 5, y + 45, this.field_230688_j_ - 10, this.field_230689_k_ - 75 - y, this.selectedQuest, selectionSize, this::onRewardSelectionChanged));
            } else {
                if (conditions.length > 0) {
                    this.addTitle(y += offset, TEXT_QUEST_CONDITIONS, TextFormatting.YELLOW, TextFormatting.BOLD);
                    for (IQuestCondition condition : conditions) {
                        this.addDetail(y += offset, condition.getDescriptor(false));
                    }
                }
                StringTextComponent tierComponent = new StringTextComponent(TextFormatting.AQUA.toString() + this.selectedQuest.getRewardTier());
                if (!isSpecial) {
                    this.addDetail(y += offset, (ITextComponent)TEXT_QUEST_TIER.apply(tierComponent), 5);
                }
                this.addTitle(y += offset, TEXT_QUEST_DETAIL, TextFormatting.YELLOW, TextFormatting.BOLD);
                List list = this.font.func_238425_b_((ITextProperties)displayInfo.getInfo().func_240699_a_(TextFormatting.ITALIC), this.field_230688_j_ - 30);
                for (IReorderingProcessor processor : list) {
                    this.addWidget(new ReorderedTextWidget(this.field_230690_l_ + 15, this.field_230691_m_ + 30 + (y += offset), this.field_230688_j_ - 30, 10, processor, this.font));
                }
                if (this.selectedQuest instanceof IAdditionalClientInfo) {
                    y += offset;
                    IAdditionalClientInfo clientInfo = (IAdditionalClientInfo)((Object)this.selectedQuest);
                    ITextComponent[] text = clientInfo.getAdditionalNotes();
                    for (int i = 0; i < text.length; ++i) {
                        ITextComponent textComponent = text[i];
                        this.addWidget(new LabelWidget(this.field_230690_l_ + 5, this.field_230691_m_ + 30 + y + i * offset, this.field_230688_j_ - 10, 10, textComponent, this.font));
                    }
                }
            }
            if (actionType != null) {
                if (isSpecial) {
                    int textWidth = this.font.func_238414_a_((ITextProperties)TEXT_QUEST_NO_REWARDS);
                    this.addWidget(new LabelWidget(this.field_230690_l_ + this.field_230688_j_ - 5 - textWidth, this.field_230689_k_ - 15, textWidth, 10, TEXT_QUEST_NO_REWARDS, this.font));
                } else if (isRewardCollectionAllowed) {
                    this.actionButton = this.addWidget(new ActionButton(this.field_230690_l_ + this.field_230688_j_ - 145, this.field_230689_k_ - 25, 140, 20, actionType, this::handleResponse));
                    IQuests quests = QuestScreen.this.questProvider;
                    Optional<Quest<?>> activeQuestOpt = quests.getActiveQuest();
                    if (actionType == ActionType.COLLECT || actionType == ActionType.ASSIGN && activeQuestOpt.isPresent() && activeQuestOpt.get() != this.selectedQuest) {
                        this.actionButton.field_230693_o_ = false;
                    }
                } else {
                    int textWidth = this.font.func_238414_a_((ITextProperties)TEXT_QUEST_OTHER_ACTIVE);
                    this.addWidget(new LabelWidget(this.field_230690_l_ + this.field_230688_j_ - 5 - textWidth, this.field_230689_k_ - 15, textWidth, 10, TEXT_QUEST_OTHER_ACTIVE, this.font));
                }
            }
        }

        private boolean shouldHideQuest(Quest<?> quest) {
            if (quest == null) {
                return true;
            }
            QuestStatus status = quest.getStatus();
            return status == QuestStatus.FAILED || status == QuestStatus.CLAIMED;
        }

        private void onRewardSelectionChanged(Integer[] choices) {
            if (this.actionButton == null) {
                return;
            }
            this.actionButton.field_230693_o_ = choices.length > 0;
            this.selectedIndexes = choices;
        }

        private void handleResponse(ActionType type) {
            MayorEntity entity = QuestScreen.this.entity;
            switch (type) {
                case ASSIGN: {
                    NetworkManager.sendServerPacket(C2S_QuestActionPacket.makeAssignPacket(entity, QuestScreen.this.quests, this.selectedQuest));
                    QuestScreen.this.refreshAllWidgets();
                    break;
                }
                case CANCEL: {
                    ConfirmDialog cancelDialog = new ConfirmDialog(QuestScreen.this, DIALOG_CANCEL_HEADER, new ITextComponent[]{DIALOG_CANCEL_INFO, DIALOG_CANCEL_DANGER}, screen -> {
                        NetworkManager.sendServerPacket(C2S_QuestActionPacket.makeCancelPacket(entity));
                        QuestScreen.this.field_230706_i_.func_147108_a(screen);
                    });
                    QuestScreen.this.field_230706_i_.func_147108_a((Screen)cancelDialog);
                    break;
                }
                case COLLECT: {
                    QuestReward reward = this.selectedQuest.getReward();
                    Integer[] indexes = this.selectedIndexes;
                    QuestReward.Choice[] choices = new QuestReward.Choice[indexes.length];
                    int j = 0;
                    Integer[] integerArray = indexes;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int index = integerArray[i];
                        QuestReward.Choice choice = reward.getChoices()[index];
                        choices[j++] = choice;
                    }
                    ItemStackDisplay[] displays = ItemStackDisplay.fromSelectedReward(choices);
                    ITextComponent[] components = new ITextComponent[displays.length + 2];
                    components[0] = DIALOG_REWARD_INFO;
                    components[1] = new StringTextComponent(" ");
                    for (int i = 0; i < displays.length; ++i) {
                        int k = i + 2;
                        ItemStackDisplay display = displays[i];
                        components[k] = new StringTextComponent(String.format("%s%dx %s%s", TextFormatting.AQUA, display.count, TextFormatting.GREEN, display.item.func_200295_i(ItemStack.field_190927_a).getString()));
                    }
                    ConfirmDialog confirmDialog = new ConfirmDialog(QuestScreen.this, DIALOG_REWARD_HEADER, components, screen -> {
                        NetworkManager.sendServerPacket(C2S_QuestActionPacket.makeCollectionPacket(entity, this.selectedIndexes));
                        QuestScreen.this.field_230706_i_.func_147108_a(screen);
                    });
                    QuestScreen.this.field_230706_i_.func_147108_a((Screen)confirmDialog);
                }
            }
        }

        private void addTitle(int y, IFormattableTextComponent component, TextFormatting ... formattings) {
            this.addWidget(new LabelWidget(this.field_230690_l_ + 5, this.field_230691_m_ + 30 + y, this.field_230688_j_ - 10, 10, (ITextComponent)component.func_240701_a_(formattings), this.font));
        }

        private void addDetail(int y, ITextComponent component) {
            this.addDetail(y, component, 15);
        }

        private void addDetail(int y, ITextComponent text, int xOffset) {
            this.addWidget(new LabelWidget(this.field_230690_l_ + xOffset, this.field_230691_m_ + 30 + y, this.field_230688_j_ - xOffset, 10, text, this.font));
        }

        private void addDetail(int y, IFormattableTextComponent component, TextFormatting ... formattings) {
            this.addDetail(y, component, 15, formattings);
        }

        private void addDetail(int y, IFormattableTextComponent text, int xOffset, TextFormatting ... formattings) {
            this.addWidget(new LabelWidget(this.field_230690_l_ + xOffset, this.field_230691_m_ + 30 + y, this.field_230688_j_ - xOffset, 10, (ITextComponent)text.func_240701_a_(formattings), this.font));
        }

        private ActionType getQuestActionType(QuestStatus status) {
            switch (status) {
                case ACTIVE: {
                    return ActionType.CANCEL;
                }
                case COMPLETED: {
                    return ActionType.COLLECT;
                }
                case CREATED: {
                    return ActionType.ASSIGN;
                }
            }
            return null;
        }
    }

    private static final class ItemStackWidget
    extends Widget {
        private final ItemStackDisplay display;
        private final FontRenderer font;
        private final ItemRenderer renderer;
        private final ITooltipRenderer tooltipRenderer;

        public ItemStackWidget(int x, int y, int width, int height, ItemStackDisplay stackDisplay, FontRenderer font, ItemRenderer renderer, ITooltipRenderer tooltipRenderer) {
            super(x, y, width, height, StringTextComponent.field_240750_d_);
            this.display = stackDisplay;
            this.font = font;
            this.renderer = renderer;
            this.tooltipRenderer = tooltipRenderer;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.renderer.func_175042_a(this.display.rendererHolder, this.field_230690_l_, this.field_230691_m_);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.0, 0.0, 400.0);
            int count = this.display.count;
            if (count > 1) {
                this.font.func_238405_a_(matrix, String.valueOf(count), (float)(this.field_230690_l_ + 8), (float)(this.field_230691_m_ + 8), 0xFFFFFF);
            }
            if (this.field_230692_n_) {
                this.tooltipRenderer.renderItemTooltip(matrix, this.display.rendererHolder, mouseX, mouseY);
            }
            matrix.func_227865_b_();
        }

        @FunctionalInterface
        private static interface ITooltipRenderer {
            public void renderItemTooltip(MatrixStack var1, ItemStack var2, int var3, int var4);
        }
    }

    private static final class QuestWidget
    extends Widget {
        private final Quest<?> quest;
        private final Consumer<QuestWidget> onClick;

        public QuestWidget(int x, int y, int width, int height, Quest<?> quest, Consumer<QuestWidget> onClick) {
            super(x, y, width, height, (ITextComponent)quest.getScheme().getDisplayInfo().getName());
            this.quest = quest;
            this.onClick = onClick;
        }

        public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
            RenderUtils.drawBorder(pose, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, 1.5f, this.field_230692_n_ ? -256 : -1);
            Minecraft.func_71410_x().field_71466_p.func_243246_a(matrix, this.func_230458_i_(), (float)this.field_230690_l_ + (float)this.field_230688_j_ * 0.05f, (float)this.field_230691_m_ + (float)(this.field_230689_k_ - 7) / 2.0f, 0xFFFFFF);
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            this.onClick.accept(this);
        }
    }
}

